/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.datagen.providers;

import java.util.Arrays;
import java.util.stream.Collectors;
import mod.traister101.sns.common.items.SNSItems;
import mod.traister101.sns.datagen.SmartLanguageProvider;
import mod.traister101.sns.util.SNSUtils;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public class BuiltIntLanguage
extends SmartLanguageProvider {
    public BuiltIntLanguage(PackOutput output) {
        super(output, "sns", "en_us");
    }

    public static String langify(String serializedName) {
        return Arrays.stream(serializedName.split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining(" "));
    }

    @Override
    protected void addTranslations() {
        this.addItemTranslations();
        this.add("sns.key.pickup", "Toggle Container Item Pickup");
        this.add("sns.key.void", "Toggle Container Item Voiding");
        this.add("sns.creative_tab.sacks", "Sacks 'N Such");
        this.add("sns.status.item_container.no_void", "%s has item voiding disabled");
        this.add("sns.status.item_container.no_pickup", "%s has item pickup disabled");
        this.add("snstooltip.item_container.tooltip.shift", "Hold (Shift) for container info");
        this.add("sns.tooltip.item_container.tooltip.pickup", "Item Pickup %s");
        this.add("sns.tooltip.item_container.tooltip.void", "Item Voiding %s");
        this.add("sns.tooltip.item_container.slot_count", "Slot Count: %s");
        this.add("sns.tooltip.item_container.slot_capacity", "Slot Capacity: %s");
        this.add("sns.tooltip.item_container.tooltip.inventory_interaction", "Inventory Interaction: %s");
        this.add("sns.tooltip.item_container.allowed_size", "Fits at most size: %s");
        this.add("sns.tooltip.lunchbox.selected_slot", "Selected Slot: %s");
        this.add(SNSUtils.ToggleType.PICKUP.langKey, "Item Pickup %s");
        this.add(SNSUtils.ToggleType.VOID.langKey, "Item Voiding %s");
        this.add("sns.enabled", "Enabled");
        this.add("sns.disabled", "Disabled");
        this.add("sns.tooltip.food_trait.lunchbox", "Lunchbox Preserved");
    }

    @Override
    protected Iterable<Item> getKnownItems() {
        return SNSItems.ITEMS.getEntries().stream().map(RegistryObject::get)::iterator;
    }

    private void addItemTranslations() {
        SNSItems.ITEMS.getEntries().forEach(this::addSimpleItem);
    }

    private void addSimpleItem(RegistryObject<Item> item) {
        this.add((Item)item.get(), BuiltIntLanguage.langify(item.getId().m_135815_()));
    }
}

